const { Schema, model, default: mongoose } = require("mongoose");
const moment = require("moment");

const each_bank = new Schema(
  {
    account_number: {
      type: String,
    },
    account_nickname: {
      type: String,
    },
    routing_number: String,
    account_name: { type: String},
    country: String,
    currency: { type: String },
    note: String,
    iban: { type: String },
    address: { type: Object },
    // city: { type: String, required: [true, "Address is required"] },
    // state: { type: String, required: [true, "State is required"] },
    // zip_code: { type: String, required: [true, "Zip code is required"] },
    sort_code: { type: String },
    account_currency: {
      type: String,
      
    },
    bank_name: { type: String},
    date: { type: Date, default: Date.now },
  },
  {
    timestamps: true,
  }
);

module.exports = model("bank_accounts", each_bank);
