const { Schema, default: mongoose, model } = require("mongoose");

const sessionModel = new Schema({
    uid: {
        type: mongoose.Types.ObjectId,
        ref: 'users',
        required: [true, 'user id is required']
    },
    device: {
        type: Object,
    },
    ip: {
        type: String,
        required: [true, 'user ip is required in session creation']
    },
    isAuth: {
        default: false,
        type: Boolean
    },
    status: {
        type: String,
        enum: ['active', 'inactive'],
        default: 'active'
    }
}, {
    timestamps: true
})

module.exports = model('sessions', sessionModel)