const { DB } = require("../../db");
const { verifySession } = require("../../middleware/verifySession");
const { createBeneficiaryValidator } = require("../../validators/bene-validate");
const Router = require("express").Router();

// Add new beneficiary
Router.post("/add/beneficiary", verifySession, async (req, res) => {
  try {
    // Validate request body
    const { error, value } = createBeneficiaryValidator.validate(req.body);
    if (error) {
      return res.status(400).json({ 
        msg: error.details[0].message 
      });
    }

    const { account_number, name, type, routing_number, localDetails, wireDetails } = value;
    const userId = req.user._id;

    console.log(account_number);
    

    // Check if beneficiary already exists
    const existingBeneficiary = await DB.BENEFICIARY.findOne({
      uid: userId,
      accountNumber: account_number
    });

    if (existingBeneficiary) {
      return res.status(400).json({ 
        msg: "Beneficiary already exists" 
      });
    }

    // Prevent self-transfer
    if (account_number === req.user.account.number) {
      return res.status(400).json({ 
        msg: "Cannot add yourself as a beneficiary" 
      });
    }

    value.uid = userId;
    if (type === "local") {
      // Validate local transfer details
      if (!localDetails) {
        return res.status(400).json({ 
          msg: "Local transfer details are required" 
        });
      }


      // Find recipient account for local transfer
      // const recipientAccount = await DB.USER.findOne({
      //   'account.number': account_number
      // });

      // if (!recipientAccount) {
      //   return res.status(404).json({ 
      //     msg: "Recipient account not found" 
      //   });
      // }

      // Create local beneficiary
      const newBeneficiary = await DB.BENEFICIARY.create({...value});

      return res.status(201).json({
        data: "Local beneficiary added successfully",
        beneficiary: {
          id: newBeneficiary._id,
          name: newBeneficiary.name,
          type: newBeneficiary.type,
          accountNumber: newBeneficiary.account_number
        }
      });
    } 
    else if (type === "wire") {
      // Validate wire transfer details
      if (!wireDetails) {
        return res.status(400).json({ 
          msg: "Wire transfer details are required" 
        });
      }

      // Verify bank details for wire transfer
      // const bankAccount = await DB.BANKS.findOne({
      //   account_number,
      //   routing_number
      // });

      // if (!bankAccount) {
      //   return res.status(404).json({ 
      //     msg: "Recipient bank account not found" 
      //   });
      // }

      // Create wire beneficiary
      const newBeneficiary = await DB.BENEFICIARY.create({...value});

      return res.status(201).json({
        data: "International beneficiary added successfully",
        beneficiary: {
          id: newBeneficiary._id,
          name: newBeneficiary.name,
          type: newBeneficiary.type,
          accountNumber: newBeneficiary.account_number
        }
      });
    } 
    else {
      return res.status(400).json({ 
        msg: "Invalid beneficiary type" 
      });
    }

  } catch (error) {
    console.error("Beneficiary creation error:", error);
    return res.status(500).json({
      msg: error.message || "An error occurred while processing your request"
    });
  }
});


// DELETE /beneficiaries/:id - Delete a beneficiary by ID
Router.delete("/beneficiaries/:id", verifySession, async (req, res) => {
  try {
    const beneficiaryId = req.params.id;
    const userId = req.user._id; // From session verification

    // 1. Verify the beneficiary exists and belongs to the user
    const beneficiary = await DB.BENEFICIARY.findOne({
      _id: beneficiaryId,
      uid: userId
    });

    if (!beneficiary) {
      return res.status(404).json({
        success: false,
        message: "Beneficiary not found or you don't have permission to delete it"
      });
    }

    // 2. Delete the beneficiary
    await DB.BENEFICIARY.deleteOne({ _id: beneficiaryId });

    // 3. Return success response
    res.status(200).json({
      success: true,
      message: "Beneficiary deleted successfully",
      deletedId: beneficiaryId
    });

  } catch (error) {
    console.error("Error deleting beneficiary:", error);
    res.status(500).json({
      success: false,
      message: error.message || "Failed to delete beneficiary"
    });
  }
});




module.exports = Router;