const joi = require("joi");

const ACCEPTED_CREATE_ACCOUNT_SCHEMA = joi
  .object({
    email: joi.string().email().required(),
    init: joi.string().required(),
    phone: joi
      .string()
      .pattern(/^[0-9+\-\s()]{7,15}$/)
      .required(),
    type: joi.string().valid("user", "admin").default("user"),
    password: joi.string().min(6).required(),
    name: joi
      .object({
        first: joi.string().lowercase().trim().required(),
        last: joi.string().lowercase().trim().required(),
      })
      .required(),
    sendEmail: joi.boolean().required(),
    suspended: joi.array().items(joi.string()),
  })
  .strict();

const ACCEPTED_LOGIN_ACCOUNT_SCHEMA = joi
  .object({
    account_number: joi.string().required(),
    password: joi.string().min(6).required(),
  })
  .strict();

const SECURE_TFA = joi
  .object({
    account_number: joi.string().required(),
    type: joi.string().valid("email", "phone", "authenticator").required(),
  })
  .strict();

const VERIFY_TFA = joi
  .object({
    code: joi.string().required(),
  })
  .strict();

const ACCEPTED_FORGOT_PWD_ACCOUNT_SCHEMA = joi
  .object({
    email: joi.string().email().required(),
  })
  .strict();

const ACCEPTED_CHANGE_PWD_ACCOUNT_SCHEMA = joi
  .object({
    old_password: joi.string().min(6).required(),
    password: joi.string().min(6).required(),
  })
  .strict();

const EDIT_ACCOUNT_SCHEMA = joi
  .object({
    email: joi.string().email(),
    vat_code: joi.string(),
    vat_status: joi.string().valid('paid','not-paid'),
    transaction_status: joi.string().lowercase().trim(),
    failed_transaction_msg:  joi.string(),
    phone: joi.string().pattern(/^[0-9+\-\s()]{7,15}$/),
    type: joi.string().valid("user", "admin"),
    name: joi.object({
      first: joi.string().lowercase().trim(),
      last: joi.string().lowercase().trim(),
    }),
    password: joi.string().min(6),
    balance: joi
      .object({
        usd: joi.required(),
        gbp: joi.required(),
        euro: joi.required(),
      })
      .strict(),
  })
  .strict();

const VIEW_NOTIFICATION = joi
  .object({
    ids: joi.array().required(),
  })
  .strict();

const CHANGE_SUPPORT = joi
  .object({
    support: joi.string().required(),
  })
  .strict();

module.exports = {
  ACCEPTED_CREATE_ACCOUNT_SCHEMA,
  ACCEPTED_LOGIN_ACCOUNT_SCHEMA,
  SECURE_TFA,
  ACCEPTED_FORGOT_PWD_ACCOUNT_SCHEMA,
  EDIT_ACCOUNT_SCHEMA,
  ACCEPTED_CHANGE_PWD_ACCOUNT_SCHEMA,
  VERIFY_TFA,
  VIEW_NOTIFICATION,
  CHANGE_SUPPORT,
};
