const { Schema, model, mongoose } = require("mongoose");

const userCardModel = new Schema(
  {
    uid: {
      type: mongoose.Types.ObjectId,
      ref: "users",
      required: [true, "user id is required"],
    },
    amount: { type: Number, default: 0 },
    card_name: {
      type: String,
      // required: [true, "Card name is required"],
    },
    card_number: {
      type: String,
      // required: [true, "Card number is required"],
    },
    cvv: {
      type: String,
      // required: [true, "Cvv number is required"],
    },
    expiry_date: {
      type: String,
      // required: [true, "Expiry date number is required"],
    },
    address: {
      type: String,
      // required: [true, "Billing address number is required"],
    },
    zip: {
      type: String,
      // required: [true, "Billing address number is required"],
    },
    status: {
      type: String,
      enum: ["pending", "approved"],
      default: "pending",
    },
    frozen: { type: Boolean, default: false },
    history: [
      {
        amount: Number,
        memo: String, //narration of transfer
        ref: String, //narration of transfer
        index: String, //narration of transfer
        status: {
          type: String,
          enum: ["pending", "successful", "rejected", "reversed"],
          default: "successful",
        },
        date: String,
        type: {
          type: String,
          enum: ["credit", "debit"],
          default: "debit",
        },
      },
    ],
  },
  {
    timestamps: true,
  }
);

module.exports = model("user_card", userCardModel);
