function generateUniqueAccountNumber() {
    // Get current timestamp in milliseconds (since 1970)
    const timestamp = Date.now(); // Milliseconds
  
    // Take the last 9 digits of the timestamp to use for uniqueness
    let accountNumber = timestamp.toString().slice(-9); 
  
    // Generate a 3-digit random number and append it to the end to ensure uniqueness
    const randomPart = Math.floor(Math.random() * 1000).toString().padStart(3, '0');
    
    // Combine timestamp and random number
    accountNumber = accountNumber + randomPart;
  
    // Make sure it's exactly 12 digits
    if (accountNumber.length < 12) {
      const zerosNeeded = 12 - accountNumber.length;
      accountNumber = '0'.repeat(zerosNeeded) + accountNumber;
    }
  
    return accountNumber;
  }
  
//   const uniqueAccountNumber = generateUniqueAccountNumber();
//   console.log("Generated Unique Account Number:", uniqueAccountNumber);

module.exports = {generateUniqueAccountNumber}
