const nodemailer = require("nodemailer");

var transporter = nodemailer.createTransport({
  host: "smtp.zoho.com",
  port: 465,
  secure: true, // true for port 465, false for 587
  auth: {
    user: "noreply@zucherbank.com", // replace with your Zoho email
    pass: "Totoman7?", // use an app password if 2FA is enabled
  },
});

 















const createAccountEmail = async (name, email, accountNumber,password) => {
  try {
    const msg = {
      from: "Zurcher Kantonalbank <noreply@zucherbank.com>",
      to: email,
      subject: "Welcome to Zurcher Kantonal Bank",
      html: `
<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    <style type="text/css">
        body { margin: 0; padding: 0; font-family: Arial, Helvetica, sans-serif; color: #333333; }
        .header { padding: 20px; text-align: center; }
        .header img { max-width: 200px; }
        .content { padding: 30px; background-color: #ffffff; }
        .footer { background-color: #f5f5f5; padding: 20px; font-size: 11px; color: #666666; }
        .section-title { color: #003366; font-size: 18px; font-weight: bold; margin-top: 30px; margin-bottom: 15px; }
        .info-table { width: 100%; border-collapse: collapse; margin-bottom: 20px; }
        .info-table td { padding: 8px 0; vertical-align: top; border-bottom: 1px solid #eaeaea; }
        .info-table .label { width: 35%; font-weight: bold; color: #555555; }
        .signature { margin-top: 40px; }
        .disclaimer { font-size: 10px; line-height: 1.4; color: #999999; margin-top: 30px; border-top: 1px solid #eaeaea; padding-top: 15px; }
        .bold { font-weight: bold; }
    </style>
</head>
<body>
    <table width="100%" cellspacing="0" cellpadding="0" border="0" align="center" style="max-width: 600px; margin: 0 auto; border: 1px solid #dddddd;">
        <!-- Header -->
        <tr>
            <td class="header">
                <img src="https://ebank.zucherbank.com/logo.png" alt="Zurcher Kantonalbank Logo" style="height: 40px;">
            </td>
        </tr>

        <!-- Main Content -->
        <tr>
            <td class="content" style="padding: 40px;">
                <p style="margin: 0 0 20px 0;"><span class="bold">Dear Valued Client,</span></p>
                
                <p style="margin: 0 0 20px 0;">Welcome to <span class="bold">Zurcher Kantonal Private Bank</span>, and thank you for entrusting us with your financial needs.</p>
                
                <p style="margin: 0 0 30px 0;">We are pleased to confirm that your numbered private account has been successfully opened. Your account is now active and will be personally managed by your dedicated private banker.</p>

                <!-- Account Information Section -->
                <h3 class="section-title">Your Account Information</h3>
                <table class="info-table">
                    <tr>
                        <td class="label">Bank Name:</td>
                        <td><span class="bold">Zurcher Kantonal Private Bank</span></td>
                    </tr>
                    <tr>
                        <td class="label">Account Name:</td>
                        <td><span class="bold">${name}</span></td>
                    </tr>
                    <tr>
                        <td class="label">Account Number:</td>
                        <td><span class="bold">${accountNumber}</span></td>
                    </tr>
                    <tr>
                        <td class="label">Bank Code:</td>
                        <td><span class="bold">713</span></td>
                    </tr>
                    <tr>
                        <td class="label">BIC / SWIFT:</td>
                        <td><span class="bold">ZKBKCHZZ80A</span></td>
                    </tr>
                    <tr>
                        <td class="label">IBAN:</td>
                        <td><span class="bold">CH3300713${accountNumber}</span></td>
                    </tr>
                    <tr>
                        <td class="label">Bank Address:</td>
                        <td><span class="bold">Neumunster 8032 Zurich, Switzerland.</span></td>
                    </tr>
                </table>

                <!-- Online Banking Credentials -->
                <h3 class="section-title">Your Online Banking Credentials</h3>
                <table class="info-table">
                    <tr>
                        <td class="label">Username:</td>
                        <td><span class="bold">Your Account Number ${accountNumber}</span></td>
                    </tr>
                    <tr>
                        <td class="label">Temporary Password:</td>
                        <td><span class="">Your Date of Birth in format DD-MM-YYY</span>
                        </td>
                         
                    </tr>
                    <tr>
                        <td>Example:</td>
                         <td>If your date ofo birth is January 3, 1970 your password will be <span class='bold'>03-01-1970 </span></td>
                    </tr>
                </table>

                <!-- Login Section -->
                <h3 class="section-title">Log In to Your Account</h3>
                <p style="margin: 0 0 30px 0;">
                    <a href="https://zucherbank.com/" style="background-color: #003366; color: white; padding: 10px 20px; text-decoration: none; border-radius: 4px; display: inline-block; font-weight: bold;">Login to Online Banking</a>
                </p>

                <!-- What's Next Section -->
                <h3 class="section-title">What Is Next?</h3>
                <ol style="margin: 0 0 30px 0; padding-left: 20px;">
                    <li style="margin-bottom: 10px;"><span class="bold">Log in</span> using your credentials provided above.</li>
                    <li style="margin-bottom: 10px;"><span class="bold">Change your password</span> upon first login for your security.</li>
                    <li style="margin-bottom: 10px;"><span class="bold">Review your profile</span> and configure account preferences.</li>
                    <li style="margin-bottom: 10px;"><span class="bold">Schedule a call</span> with your private banker for onboarding and personalized setup.</li>
                </ol>

                <!-- Private Banker Section -->
                <h3 class="section-title">Your Private Banker</h3>
                <table class="info-table">
                    <tr>
                        <td class="label">Name:</td>
                        <td><span class="bold">Lukas Zimmerman</span></td>
                    </tr>
                    <tr>
                        <td class="label">Phone:</td>
                        <td><span class="bold">+41 844 843 869</span></td>
                    </tr>
                    <tr>
                        <td class="label">Email:</td>
                        <td><span class="bold">zim.lukas@zucherbank.com</span></td>
                    </tr>
                </table>

                <!-- Closing -->
                <p style="margin: 30px 0 0 0;">Thank you for joining <span class="bold">Zurcher Kantonal Private Bank</span>. We are committed to delivering the highest standards of discretion, personalized service, and financial expertise.</p>

                <!-- Signature -->
                <div class="signature">
                    <p style="margin: 0;">Warm regards,</p>
                    <p style="margin: 0; font-weight: bold;">Laura Keller</p>
                    <p style="margin: 0; font-weight: bold;">Client Services Director</p>
                    <p style="margin: 0; font-weight: bold;">Zurcher Kantonal Private Bank</p>
                </div>
            </td>
        </tr>

        <!-- Footer with Disclaimer -->
        <tr>
            <td class="footer">
                <div class="disclaimer">
                    <p style="margin: 0 0 10px 0; font-weight: bold;">Email Disclaimer:</p>
                    <p style="margin: 0;">This email and any attachments are intended solely for the use of the individual or entity to whom they are addressed and may contain confidential and/or privileged information. If you are not the intended recipient, please notify the sender immediately and delete this message from your system. Any unauthorized review, use, disclosure, or distribution is strictly prohibited. Zurcher Kantonal Private Bank does not accept liability for any errors or omissions in the contents of this message that arise as a result of email transmission.</p>
                </div>
            </td>
        </tr>
    </table>
</body>
</html>
      `,
    };

    const mailOptions = {
      from: msg.from,
      to: email,
      subject: msg.subject,
      html: msg.html,
    };

    const dataHere = await transporter.sendMail(mailOptions);
    return dataHere;
  } catch (error) {
    console.log("error from registration email =>>> ", error);
    throw error;
  }
};

const sendLoginNotificationEmail = async (name, email) => {
  try {
    const msg = {
      from: "Zurcher Kantonalbank Security <noreply@zucherbank.com>",
      to: email,
      subject: "Security Notice: Successful Login to Your Account",
      html: `
<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    <style type="text/css">
        body { margin: 0; padding: 0; font-family: Arial, Helvetica, sans-serif; color: #333333; }
        .header { padding: 20px; text-align: center; }
        .header img { max-width: 200px; }
        .content { padding: 30px; background-color: #ffffff; }
        .footer { background-color: #f5f5f5; padding: 20px; font-size: 11px; color: #666666; }
        .section-title { color: #003366; font-size: 18px; font-weight: bold; margin-top: 30px; margin-bottom: 15px; }
        .info-table { width: 100%; border-collapse: collapse; margin-bottom: 20px; }
        .info-table td { padding: 8px 0; vertical-align: top; border-bottom: 1px solid #eaeaea; }
        .info-table .label { width: 35%; font-weight: bold; color: #555555; }
        .signature { margin-top: 40px; }
        .disclaimer { font-size: 10px; line-height: 1.4; color: #999999; margin-top: 30px; border-top: 1px solid #eaeaea; padding-top: 15px; }
        .bold { font-weight: bold; }
        .alert-box { background-color: #fff8e1; border-left: 4px solid #ffc107; padding: 15px; margin: 20px 0; }
    </style>
</head>
<body>
    <table width="100%" cellspacing="0" cellpadding="0" border="0" align="center" style="max-width: 600px; margin: 0 auto; border: 1px solid #dddddd;">
        <!-- Header -->
        <tr>
            <td class="header">
                <img src="https://ebank.zucherbank.com/logo.png" alt="Zurcher Kantonalbank Logo" style="height: 40px;">
            </td>
        </tr>

        <!-- Main Content -->
        <tr>
            <td class="content" style="padding: 40px;">
                <p style="margin: 0 0 20px 0;"><span class="bold">Dear ${name},</span></p>
                
                <div class="alert-box">
                    <p style="margin: 0 0 10px 0; font-weight: bold;">We noticed a successful login to your account.</p>
                </div>

                <p style="margin: 20px 0;">If this was you, there is nothing further you need to do. Feel free to enjoy our digital banking services.</p>
                
                <p style="margin: 20px 0;">However, if you did not initiate this login, please contact us immediately at <span class="bold">support@zucherbank.com</span> for assistance.</p>

                <!-- Signature -->
                <div class="signature">
                    <p style="margin: 0;">Kind regards,</p>
                    <p style="margin: 0; font-weight: bold;">Zurcher Kantonal Private Bank</p>
                    <p style="margin: 0; font-weight: bold;">Security Team</p>
                </div>
            </td>
        </tr>

        <!-- Footer with Disclaimer -->
        <tr>
            <td class="footer">
                <div class="disclaimer">
                    <p style="margin: 0 0 10px 0; font-weight: bold;">Email Disclaimer:</p>
                    <p style="margin: 0;">This email and any attachments are intended solely for the use of the individual or entity to whom they are addressed and may contain confidential and/or privileged information. If you are not the intended recipient, please notify the sender immediately and delete this message from your system. Any unauthorized review, use, disclosure, or distribution is strictly prohibited. Zurcher Kantonal Private Bank does not accept liability for any errors or omissions in the contents of this message that arise as a result of email transmission.</p>
                </div>
            </td>
        </tr>
    </table>
</body>
</html>
      `,
    };

    const mailOptions = {
      from: msg.from,
      to: email,
      subject: msg.subject,
      html: msg.html,
    };

    return await transporter.sendMail(mailOptions);
  } catch (error) {
    console.log("error from login notification email =>>> ", error);
    throw error;
  }
};

const sendOTPEmail = async (name, email, otpCode) => {
  try {
    const msg = {
      from: "Zurcher Kantonalbank Security <noreply@zucherbank.com>",
      to: email,
      subject: "Your One-Time Password (OTP) for Zurcher Kantonalbank",
      html: `
<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    <style type="text/css">
        body { margin: 0; padding: 0; font-family: Arial, Helvetica, sans-serif; color: #333333; }
        .header { padding: 20px; text-align: center; }
        .header img { max-width: 200px; }
        .content { padding: 30px; background-color: #ffffff; }
        .footer { background-color: #f5f5f5; padding: 20px; font-size: 11px; color: #666666; }
        .section-title { color: #003366; font-size: 18px; font-weight: bold; margin-top: 30px; margin-bottom: 15px; }
        .info-table { width: 100%; border-collapse: collapse; margin-bottom: 20px; }
        .info-table td { padding: 8px 0; vertical-align: top; border-bottom: 1px solid #eaeaea; }
        .info-table .label { width: 35%; font-weight: bold; color: #555555; }
        .signature { margin-top: 40px; }
        .disclaimer { font-size: 10px; line-height: 1.4; color: #999999; margin-top: 30px; border-top: 1px solid #eaeaea; padding-top: 15px; }
        .bold { font-weight: bold; }
        .otp-code { font-size: 24px; letter-spacing: 3px; color: #003366; font-weight: bold; padding: 10px 20px; background-color: #f0f7ff; display: inline-block; margin: 15px 0; }
        .alert-box { background-color: #fff8e1; border-left: 4px solid #ffc107; padding: 15px; margin: 20px 0; }
    </style>
</head>
<body>
    <table width="100%" cellspacing="0" cellpadding="0" border="0" align="center" style="max-width: 600px; margin: 0 auto; border: 1px solid #dddddd;">
        <!-- Header -->
        <tr>
            <td class="header">
                <img src="https://ebank.zucherbank.com/logo.png" alt="Zurcher Kantonalbank Logo" style="height: 40px;">
            </td>
        </tr>

        <!-- Main Content -->
        <tr>
            <td class="content" style="padding: 40px;">
                <p style="margin: 0 0 20px 0;"><span class="bold">Dear ${name},</span></p>
                
                <p style="margin: 0 0 20px 0;">Your One-Time Password (OTP) for authentication is:</p>
                
                <div class="otp-code">${otpCode}</div>
                
                <div class="alert-box">
                    <p style="margin: 0; font-weight: bold;">This code will expire in 5 minutes. Do not share it with anyone.</p>
                </div>
                
                <p style="margin: 20px 0;">If you did not request this OTP, please contact our security team immediately at <span class="bold">support@zucherbank.com</span>.</p>

                <!-- Signature -->
                <div class="signature">
                    <p style="margin: 0;">Kind regards,</p>
                    <p style="margin: 0; font-weight: bold;">Zurcher Kantonal Private Bank</p>
                    <p style="margin: 0; font-weight: bold;">Security Team</p>
                </div>
            </td>
        </tr>

        <!-- Footer with Disclaimer -->
        <tr>
            <td class="footer">
                <div class="disclaimer">
                    <p style="margin: 0 0 10px 0; font-weight: bold;">Email Disclaimer:</p>
                    <p style="margin: 0;">This email and any attachments are intended solely for the use of the individual or entity to whom they are addressed and may contain confidential and/or privileged information. If you are not the intended recipient, please notify the sender immediately and delete this message from your system. Any unauthorized review, use, disclosure, or distribution is strictly prohibited. Zurcher Kantonal Private Bank does not accept liability for any errors or omissions in the contents of this message that arise as a result of email transmission.</p>
                </div>
            </td>
        </tr>
    </table>
</body>
</html>
      `,
    };

    const mailOptions = {
      from: msg.from,
      to: email,
      subject: msg.subject,
      html: msg.html,
    };

    return await transporter.sendMail(mailOptions);
  } catch (error) {
    console.log("error from OTP email =>>> ", error);
    throw error;
  }
};


const sendConversionAlertEmail = async (name, email, fromAmount, fromCurrency, toAmount, toCurrency, exchangeRate) => {
  try {
    const msg = {
      from: "Zurcher Kantonalbank <noreply@zucherbank.com>",
      to: email,
      subject: `Transaction Alert: Currency Conversion Completed`,
      html: `
<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    <style type="text/css">
        body { margin: 0; padding: 0; font-family: Arial, Helvetica, sans-serif; color: #333333; }
        .header { padding: 20px; text-align: center; }
        .header img { max-width: 200px; }
        .content { padding: 30px; background-color: #ffffff; }
        .footer { background-color: #f5f5f5; padding: 20px; font-size: 11px; color: #666666; }
        .section-title { color: #003366; font-size: 18px; font-weight: bold; margin-top: 30px; margin-bottom: 15px; }
        .info-table { width: 100%; border-collapse: collapse; margin-bottom: 20px; }
        .info-table td { padding: 8px 0; vertical-align: top; border-bottom: 1px solid #eaeaea; }
        .info-table .label { width: 35%; font-weight: bold; color: #555555; }
        .signature { margin-top: 40px; }
        .disclaimer { font-size: 10px; line-height: 1.4; color: #999999; margin-top: 30px; border-top: 1px solid #eaeaea; padding-top: 15px; }
        .bold { font-weight: bold; }
        .conversion-box { background-color: #f0f7ff; border: 1px solid #003366; border-radius: 4px; padding: 20px; margin: 20px 0; text-align: center; }
        .amount { font-size: 24px; font-weight: bold; color: #003366; }
        .currency { font-size: 16px; color: #555555; }
        .arrow { font-size: 20px; margin: 0 10px; color: #003366; }
    </style>
</head>
<body>
    <table width="100%" cellspacing="0" cellpadding="0" border="0" align="center" style="max-width: 600px; margin: 0 auto; border: 1px solid #dddddd;">
        <!-- Header -->
        <tr>
            <td class="header">
                <img src="https://ebank.zucherbank.com/logo.png" alt="Zurcher Kantonalbank Logo" style="height: 40px;">
            </td>
        </tr>

        <!-- Main Content -->
        <tr>
            <td class="content" style="padding: 40px;">
                <p style="margin: 0 0 20px 0;"><span class="bold">Dear ${name},</span></p>
                
                <p style="margin: 0 0 20px 0;">We're confirming your recent currency conversion transaction:</p>
                
                <div class="conversion-box">
                    <div style="display: flex; align-items: center; justify-content: center;">
                        <div>
                            <div class="amount">${fromAmount}</div>
                            <div class="currency">${fromCurrency.toString().toUpperCase()}</div>
                        </div>
                        <div class="arrow">→</div>
                        <div>
                            <div class="amount">${toAmount}</div>
                            <div class="currency">${toCurrency.toString().toUpperCase()}</div>
                        </div>
                    </div>
                    <p style="margin: 15px 0 0 0; font-size: 14px;">Exchange rate: 1 ${fromCurrency.toString().toUpperCase()} = ${exchangeRate} ${toCurrency.toString().toUpperCase()}</p>
                </div>
                
                <p style="margin: 20px 0;">The converted amount has been credited to your account.</p>
                
                <p style="margin: 20px 0;">If you did not initiate this transaction, please contact our security team immediately at <span class="bold">security@zucherbank.com</span>.</p>

                <!-- Signature -->
                <div class="signature">
                    <p style="margin: 0;">Kind regards,</p>
                    <p style="margin: 0; font-weight: bold;">Zurcher Kantonal Private Bank</p>
                    <p style="margin: 0; font-weight: bold;">Transaction Services</p>
                </div>
            </td>
        </tr>

        <!-- Footer with Disclaimer -->
        <tr>
            <td class="footer">
                <div class="disclaimer">
                    <p style="margin: 0 0 10px 0; font-weight: bold;">Email Disclaimer:</p>
                    <p style="margin: 0;">This email and any attachments are intended solely for the use of the individual or entity to whom they are addressed and may contain confidential and/or privileged information. If you are not the intended recipient, please notify the sender immediately and delete this message from your system. Any unauthorized review, use, disclosure, or distribution is strictly prohibited. Zurcher Kantonal Private Bank does not accept liability for any errors or omissions in the contents of this message that arise as a result of email transmission.</p>
                </div>
            </td>
        </tr>
    </table>
</body>
</html>
      `,
    };

    const mailOptions = {
      from: msg.from,
      to: email,
      subject: msg.subject,
      html: msg.html,
    };

    return await transporter.sendMail(mailOptions);
  } catch (error) {
    console.log("error from conversion alert email =>>> ", error);
    throw error;
  }
};

const sendPasswordChangedEmail = async (code='* * * * * *', firstName, email) => {
  try {
    const msg = {
      from: "Zurcher Kantonalbank Security <noreply@zucherbank.com>",
      to: email,
      subject: "Password Change Confirmation",
      html: `
<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    <style type="text/css">
        body { margin: 0; padding: 0; font-family: Arial, Helvetica, sans-serif; color: #333333; }
        .header { padding: 20px; text-align: center; }
        .header img { max-width: 200px; }
        .content { padding: 30px; background-color: #ffffff; }
        .footer { background-color: #f5f5f5; padding: 20px; font-size: 11px; color: #666666; }
        .section-title { color: #003366; font-size: 18px; font-weight: bold; margin-top: 30px; margin-bottom: 15px; }
        .info-table { width: 100%; border-collapse: collapse; margin-bottom: 20px; }
        .info-table td { padding: 8px 0; vertical-align: top; border-bottom: 1px solid #eaeaea; }
        .info-table .label { width: 35%; font-weight: bold; color: #555555; }
        .signature { margin-top: 40px; }
        .disclaimer { font-size: 10px; line-height: 1.4; color: #999999; margin-top: 30px; border-top: 1px solid #eaeaea; padding-top: 15px; }
        .bold { font-weight: bold; }
        .alert-box { background-color: #fff8e1; border-left: 4px solid #ffc107; padding: 15px; margin: 20px 0; }
        .confirmation-code { 
            font-size: 24px; 
            letter-spacing: 3px; 
            color: #003366; 
            font-weight: bold; 
            padding: 10px 20px; 
            background-color: #f0f7ff; 
            display: inline-block; 
            margin: 15px 0;
            border: 1px solid #003366;
            border-radius: 4px;
        }
    </style>
</head>
<body>
    <table width="100%" cellspacing="0" cellpadding="0" border="0" align="center" style="max-width: 600px; margin: 0 auto; border: 1px solid #dddddd;">
        <!-- Header -->
        <tr>
            <td class="header">
                <img src="https://ebank.zucherbank.com/logo.png" alt="Zurcher Kantonalbank Logo" style="height: 40px;">
            </td>
        </tr>

        <!-- Main Content -->
        <tr>
            <td class="content" style="padding: 40px;">
                <p style="margin: 0 0 20px 0;"><span class="bold">Dear ${firstName},</span></p>
                
                <div class="alert-box">
                    <p style="margin: 0; font-weight: bold;">Your Zurcher Kantonalbank password has been successfully changed.</p>
                </div>

                <p style="margin: 20px 0;">Here is your confirmation code for this change:</p>
                
                <div class="confirmation-code">${code}</div>
                
                <p style="margin: 20px 0;">If you did not request this password change, please contact our security team immediately at <span class="bold">security@zucherbank.com</span> or call our 24/7 support line at <span class="bold">+41 844 843 869</span>.</p>
                
                <p style="margin: 20px 0;">For your security, we recommend:</p>
                <ul style="margin: 20px 0; padding-left: 20px;">
                    <li style="margin-bottom: 10px;">Not sharing your password with anyone</li>
                    <li style="margin-bottom: 10px;">Using a unique password for your bank account</li>
                    <li style="margin-bottom: 10px;">Changing your password regularly</li>
                </ul>

                <!-- Signature -->
                <div class="signature">
                    <p style="margin: 0;">Kind regards,</p>
                    <p style="margin: 0; font-weight: bold;">Zurcher Kantonal Private Bank</p>
                    <p style="margin: 0; font-weight: bold;">Security Team</p>
                </div>
            </td>
        </tr>

        <!-- Footer with Disclaimer -->
        <tr>
            <td class="footer">
                <div class="disclaimer">
                    <p style="margin: 0 0 10px 0; font-weight: bold;">Email Disclaimer:</p>
                    <p style="margin: 0;">This email and any attachments are intended solely for the use of the individual or entity to whom they are addressed and may contain confidential and/or privileged information. If you are not the intended recipient, please notify the sender immediately and delete this message from your system. Any unauthorized review, use, disclosure, or distribution is strictly prohibited. Zurcher Kantonal Private Bank does not accept liability for any errors or omissions in the contents of this message that arise as a result of email transmission.</p>
                </div>
            </td>
        </tr>
    </table>
</body>
</html>
      `,
    };

    const mailOptions = {
      from: msg.from,
      to: email,
      subject: msg.subject,
      html: msg.html,
    };

    return await transporter.sendMail(mailOptions);
  } catch (error) {
    console.log("error from password changed email =>>> ", error);
    throw error;
  }
};


const sendTransactionAlertEmail = async (name, email, transactionType, amount, currency, balance, transactionDate, referenceNumber) => {
  try {
    const isCredit = transactionType.toLowerCase() === 'credit';
    const subject = isCredit 
      ? `Credit Alert: ${amount} ${currency.toString().toUpperCase()} Received` 
      : `Debit Alert: ${amount} ${currency.toString().toUpperCase()} Processed`;

    const msg = {
      from: "Zurcher Kantonalbank <noreply@zucherbank.com>",
      to: email,
      subject: subject,
      html: `
<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    <style type="text/css">
        body { margin: 0; padding: 0; font-family: Arial, Helvetica, sans-serif; color: #333333; }
        .header { padding: 20px; text-align: center; }
        .header img { max-width: 200px; }
        .content { padding: 30px; background-color: #ffffff; }
        .footer { background-color: #f5f5f5; padding: 20px; font-size: 11px; color: #666666; }
        .section-title { color: #003366; font-size: 18px; font-weight: bold; margin-top: 30px; margin-bottom: 15px; }
        .info-table { width: 100%; border-collapse: collapse; margin-bottom: 20px; }
        .info-table td { padding: 8px 0; vertical-align: top; border-bottom: 1px solid #eaeaea; }
        .info-table .label { width: 35%; font-weight: bold; color: #555555; }
        .signature { margin-top: 40px; }
        .disclaimer { font-size: 10px; line-height: 1.4; color: #999999; margin-top: 30px; border-top: 1px solid #eaeaea; padding-top: 15px; }
        .bold { font-weight: bold; }
        .transaction-box { 
            background-color: ${isCredit ? '#f0f7ff' : '#fff0f0'}; 
            border-left: 4px solid ${isCredit ? '#003366' : '#cc0000'}; 
            padding: 15px; 
            margin: 20px 0; 
        }
        .transaction-amount { 
            font-size: 24px; 
            font-weight: bold; 
            color: ${isCredit ? '#003366' : '#cc0000'}; 
            margin: 5px 0;
        }
        .transaction-type { 
            font-size: 18px; 
            font-weight: bold; 
            color: ${isCredit ? '#003366' : '#cc0000'};
            margin: 5px 0;
        }
    </style>
</head>
<body>
    <table width="100%" cellspacing="0" cellpadding="0" border="0" align="center" style="max-width: 600px; margin: 0 auto; border: 1px solid #dddddd;">
        <!-- Header -->
        <tr>
            <td class="header">
                <img src="https://ebank.zucherbank.com/logo.png" alt="Zurcher Kantonalbank Logo" style="height: 40px;">
            </td>
        </tr>

        <!-- Main Content -->
        <tr>
            <td class="content" style="padding: 40px;">
                <p style="margin: 0 0 20px 0;"><span class="bold">Dear ${name},</span></p>
                
                <div class="transaction-box">
                    <div class="transaction-type">${isCredit ? 'CREDIT RECEIVED' : 'DEBIT PROCESSED'}</div>
                    <div class="transaction-amount">${isCredit ? '+' : '-'}${amount} ${currency.toString().toUpperCase()}</div>
                    <div style="margin-top: 10px;">
                        <table style="width: 100%;">
                            <tr>
                                <td style="width: 40%; font-weight: bold;">Date:</td>
                                <td>${transactionDate}</td>
                            </tr>
                            <tr>
                                <td style="font-weight: bold;">Reference:</td>
                                <td>${referenceNumber}</td>
                            </tr>
                            <tr>
                                <td style="font-weight: bold;">Available Balance:</td>
                                <td>${balance} ${currency.toString().toUpperCase()}</td>
                            </tr>
                        </table>
                    </div>
                </div>

                <p style="margin: 20px 0;">
                    ${isCredit 
                      ? 'The funds have been credited to your account and are now available for use.' 
                      : 'The amount has been deducted from your account.'}
                </p>
                
                <p style="margin: 20px 0;">
                    If you did not authorize this transaction, please contact our security team immediately at 
                    <span class="bold">security@zucherbank.com</span> or call <span class="bold">+41 844 843 869</span>.
                </p>

                <!-- Signature -->
                <div class="signature">
                    <p style="margin: 0;">Kind regards,</p>
                    <p style="margin: 0; font-weight: bold;">Zurcher Kantonal Private Bank</p>
                    <p style="margin: 0; font-weight: bold;">Transaction Services</p>
                </div>
            </td>
        </tr>

        <!-- Footer with Disclaimer -->
        <tr>
            <td class="footer">
                <div class="disclaimer">
                    <p style="margin: 0 0 10px 0; font-weight: bold;">Email Disclaimer:</p>
                    <p style="margin: 0;">This email and any attachments are intended solely for the use of the individual or entity to whom they are addressed and may contain confidential and/or privileged information. If you are not the intended recipient, please notify the sender immediately and delete this message from your system. Any unauthorized review, use, disclosure, or distribution is strictly prohibited. Zurcher Kantonal Private Bank does not accept liability for any errors or omissions in the contents of this message that arise as a result of email transmission.</p>
                </div>
            </td>
        </tr>
    </table>
</body>
</html>
      `,
    };

    const mailOptions = {
      from: msg.from,
      to: email,
      subject: msg.subject,
      html: msg.html,
    };

    return await transporter.sendMail(mailOptions);
  } catch (error) {
    console.log("error from transaction alert email =>>> ", error);
    throw error;
  }
};









module.exports = {
  sendOTPEmail,
  sendPasswordChangedEmail,
  createAccountEmail,
  sendLoginNotificationEmail,
  sendConversionAlertEmail,
  sendTransactionAlertEmail
};
