const { DB } = require("../../db");
const { BCRYPT } = require("../../helper/bcrypt");
const { BLOCK_TRANSFER } = require("../../helper/constant");
const {
  generateUniqueAccountNumber,
} = require("../../helper/generateAccountNumber");
const {
  sendEmail,
  sendPasswordChangedEmail,
  createAccountEmail,
  sendOTPEmail,
  sendLoginNotificationEmail,
} = require("../../helper/sendEmail");
const { sendSMS } = require("../../helper/sendSMS");
const checkUserSuspensionStatusWith = require("../../helper/validateSuspension");
const { verifyAdmin } = require("../../middleware/verifyAdmin");
const { verifySession } = require("../../middleware/verifySession");
const {
  ACCEPTED_CREATE_ACCOUNT_SCHEMA,
  ACCEPTED_LOGIN_ACCOUNT_SCHEMA,
  ACCEPTED_FORGOT_PWD_ACCOUNT_SCHEMA,
  ACCEPTED_CHANGE_PWD_ACCOUNT_SCHEMA,
} = require("../../validators/account");
const fs = require("fs");
const path = require("path");
var multipart = require("connect-multiparty");
var multipartMiddleware = multipart();
var cloudinary = require("cloudinary").v2;

cloudinary.config({
  cloud_name: "damrxxkrp",
  api_key: "677873915852572",
  api_secret: "aS6xTEMcu9JSkiN-DMsZtxf0rXY",
  secure: true,
});


const Router = require("express").Router();

function filterOnlyFalseFields(obj) {
  return Object.fromEntries(
    Object.entries(obj).filter(([_, value]) => value !== false)
  );
}

// CREATE USER ACCOUNT
Router.post("/create", verifySession, verifyAdmin, multipartMiddleware, async (req, res) => {
  try {
    // let { error, value } = ACCEPTED_CREATE_ACCOUNT_SCHEMA.validate(req.body);
    // if (error) throw new Error(error.details[0].message);


    // // check if the user has already uploaded a picture before and delete it from cloudinary
    // if (findUser?.img?.public_id) {
    //   // delete the image HERE
    //   const uploadingData = await cloudinary.uploader.destroy(
    //     findUser?.img?.public_id
    //   );
    // }

    // check if the user email or phone already exists
    let { email, phone } = req.body;

    // extract from db

    let userInfoExists = await DB.USER.findOne({
      $or: [{ email }, { phone }],
    }).select(["phone", "email"]);

    if (userInfoExists)
      throw new Error(
        userInfoExists._doc.phone === phone
          ? "Phone belongs to an existing account"
          : "Email belongs to an existing account."
      );

      
    // upload the image here
    const uploadingData = await cloudinary.uploader.upload(
      req.files.photo.path
    );

    // create a new account here if the info do not exist
    let newUser = await DB.USER.create({
      ...req.body,
      name: JSON.parse(req.body.name),
      image: uploadingData.url, img: uploadingData,
      password: await BCRYPT.hashPassword(req.body.password),
      account: {
        number: generateUniqueAccountNumber(),
        balance: {
          usd: parseFloat(req.body.init) || 0,
          gbp: 0,
          euro: 0,
        },
      },
      tfa: {
        token: null,
        status: "inactive",
      },
    });

    res.status(201).json({
      data: "account creation process completed",
    });

    if (req.body.sendEmail) {
      createAccountEmail(`${newUser.name.first} ${newUser.name.last}`, newUser.email,newUser.account.number , req.body.password);
    }

    await DB.NOTIFICATION.create({
      uid: newUser._id,
      type: "alert",
      body: {
        title: "Account Creation Success",
        // READING AND REPLACING WHERE {{NAME FOR THE REAL NAME}} ALL THE FILE SYSTEM
        text: "🎉 Success! Your account has been created. Welcome aboard!",

        // CHANGING ALL THE FILE SYSTEM
        // text: fs.writeFileSync(path.join(process.cwd()+"/messages/welcome.txt" ) , 'this is the change i wanted to show you')
      },
    });

    // email cl of the info created
  } catch (error) {
    res.status(500).json({
      msg: error.message || "unable to complete request.",
    });
  }
});

//login
Router.post("/login", async (req, res) => {
  try {
    let { error, value } = ACCEPTED_LOGIN_ACCOUNT_SCHEMA.validate(req.body);
    if (error) throw new Error(error.details[0].message);
    //
    let { account_number, password } = value;
    //  check if user exists
    let emailExists = await DB.USER.findOne({
      "account.number": account_number,
    }).select("account email name phone password _id tfa otp");

    // if not email exist
    if (!emailExists)
      throw new Error("invalid username and password combination");

    let pwdMatch = await BCRYPT.compareHash(password, emailExists.password);

    if (!pwdMatch) throw new Error("invalid username and password combination");

    // delete all existing sessions if the user session pass 3
    let allUserSessions = await DB.SESSION.find({ uid: emailExists._id });

    if (allUserSessions.length > 2) {
      // delete all sessions to manage db
      await DB.SESSION.deleteMany({ uid: emailExists._id.toString() });
    }

    // create a session
    let newSession = await DB.SESSION.create({
      uid: emailExists._id,
      ip: req.ip,
      device: filterOnlyFalseFields(req.useragent),
      isAuth: emailExists.tfa.status === "active" ? false : true,
    });

    await DB.NOTIFICATION.create({
      uid: emailExists._id,
      type: "alert",
      body: {
        title: "Account Login",
        text: `New login from device ${newSession.device?.browser} on ${newSession.device?.platform} - ${newSession.ip}`,
      },
    });

    await sendLoginNotificationEmail(emailExists.name.first,emailExists.email)

    const code = Math.random().toString(20).split("").splice(2, 6).join("");
    const text = `Verify your account with this one time code. Copy the code below to authorize your device using the activation code ${code}`;

    if (emailExists.tfa.status == "active") {
      if (emailExists.otp.direction === "email") {
        emailExists.otp = { code, direction: "email" };
        await emailExists.save();

        // send NOTIFICATION DETAILS from EMAIL
        await sendOTPEmail(emailExists.name.first, emailExists.email,code);
      }

      if (emailExists.otp.direction === "phone") {
        emailExists.otp = { code, direction: "phone" };
        await emailExists.save();

        // send NOTIFICATION DETAILS from PHONE
        await sendSMS(emailExists.phone, text);
      }
    }

    res.json({
      data: newSession._id,
    });
  } catch (error) {
    console.log(error);

    res.status(500).json({
      msg: error.message || "unable to complete request.",
    });
  }
});

// verify session
Router.get("/session/:id", async (req, res) => {
  try {
    const findSession = await DB.SESSION.findById(req.params.id);
    if (!findSession)
      throw new Error("Can't find session with the required ID");

    res.json({
      data: findSession,
    });
  } catch (error) {
    console.log(error);
    res.status(500).json({
      msg: error.message || "unable to complete request",
    });
  }
});

// view profile
Router.get("/profile", verifySession, async (req, res) => {
  try {
    await checkUserSuspensionStatusWith(req.user._id, BLOCK_TRANSFER);
    let userInSession = await DB.USER.findOne({ _id: req.user._id }).select(
      "-password -tfa.token"
    );
    res.json({ data: userInSession });
  } catch (error) {
    console.log(error);
    res.status(500).json({
      msg: error.message || "unable to complete request",
    });
  }
});

// forgot pwd
Router.put("/password/reset", verifySession, async (req, res) => {
  try {
    let { error, value } = ACCEPTED_FORGOT_PWD_ACCOUNT_SCHEMA.validate(
      req.body
    );
    if (error) throw new Error(error.details[0].message);
    let userExist = await DB.USER.findOne({ email: value.email });
    if (!userExist)
      throw new Error("invalid email provided, account not founded");
    // email pwd here
    // reset here
    res.status(201).json({
      data: "password reset is successful, check your email to continue",
    });
  } catch (error) {
    res.status(500).json({
      msg: error.message || "unable to complete request",
    });
  }
});

// change pwd
Router.put("/change/password", verifySession, async (req, res) => {
  try {
    let { error, value } = ACCEPTED_CHANGE_PWD_ACCOUNT_SCHEMA.validate(
      req.body
    );
    if (error) throw new Error(error.details[0].message);

    let pwdMatch = await BCRYPT.compareHash(
      value.old_password,
      req.user.password
    );
    if (!pwdMatch) throw new Error("Invalid old password combination");

    await DB.USER.findByIdAndUpdate(
      req.user._id,
      { password: await BCRYPT.hashPassword(value.password) },
      { new: true }
    );
    const code = Math.random().toString(20).split("").splice(2, 6).join("");

    sendPasswordChangedEmail(code, req.user.name.first, req.user.email);

    await DB.NOTIFICATION.create({
      uid: req.user._id,
      type: "info",
      body: {
        title: "Password Changed Successfully",
        text: "Your password was changed successfully. If you did not make this change, please reset your password immediately or contact support.",

        // CHANGING ALL THE FILE SYSTEM
        // text: fs.writeFileSync(path.join(process.cwd()+"/messages/welcome.txt" ) , 'this is the change i wanted to show you')
      },
    });

    // email pwd here
    // reset here
    res.status(201).json({
      data: "password change completed",
    });
  } catch (error) {
    res.status(500).json({
      msg: error.message || "unable to complete request",
    });
  }
});

module.exports = Router;
