const { DB } = require("../../db");
const { verifySession } = require("../../middleware/verifySession");
const { verifyAdmin } = require("../../middleware/verifyAdmin");
const Router = require("express").Router();
const {
  VALIDATE_BANK_ACCOUNT_SCHEMA,
  VALIDATE_EDIT_BANK_ACCOUNT_SCHEMA,
} = require("../../validators/bank.validator");

// su add bank by admin
Router.post(
  "/add/bank/account",
  verifySession,
  verifyAdmin,
  async (req, res) => {
    try {
      console.log("sdjfhd.");

      // let { error, value } = VALIDATE_BANK_ACCOUNT_SCHEMA.validate(req.body);
      // if (error) throw new Error(error.details[0].message);

      await DB.BANKS.create({ ...req.body });

      res.status(201).json({
        data: "request completed",
      });
    } catch (error) {
      res.status(500).json({
        msg: error.message || "unable to complete request.",
      });
    }
  }
);

// su edit bank by admin
Router.put("/edit/bank/:id", verifySession, verifyAdmin, async (req, res) => {
  try {
    // let { error, value } = VALIDATE_EDIT_BANK_ACCOUNT_SCHEMA.validate(req.body);
    // if (error) throw new Error(error.details[0].message);

    await DB.BANKS.findByIdAndUpdate(
      req.params.id,
      { ...req.body },
      { new: true }
    );

    res.status(201).json({
      data: "request completed",
    });
  } catch (error) {
    res.status(500).json({
      msg: error.message || "unable to complete request.",
    });
  }
});

// su get all banks
Router.get(
  "/list/banks/account",
  verifySession,
  verifyAdmin,
  async (req, res) => {
    try {
      const abcd = await DB.BANKS.find().sort({ createdAt: -1 });

      res.status(201).json({
        data: abcd,
      });
    } catch (error) {
      res.status(500).json({
        msg: error.message || "unable to complete request.",
      });
    }
  }
);

// su delete each banks
Router.delete(
  "/delete/bank/:id",
  verifySession,
  verifyAdmin,
  async (req, res) => {
    try {
      await DB.BANKS.findByIdAndDelete(req.params.id);

      res.status(201).json({
        data: "process completed",
      });
    } catch (error) {
      res.status(500).json({
        msg: error.message || "unable to complete request.",
        okl,
      });
    }
  }
);

module.exports = Router;
