/**
 * Financial Constants
 * 
 * This file contains all the constant values used across the application
 * related to banking, transfers, and financial operations.
 */

module.exports = {
  // Beneficiary types
  BENEFICIARY_TYPES: ['local', 'wire'],
  
  // Supported country codes (ISO 3166-1 alpha-2)
  COUNTRY_CODES: [
    'AF', 'AL', 'DZ', 'AS', 'AD', 'AO', 'AI', 'AQ', 'AG', 'AR', 'AM', 'AW', 
    'AU', 'AT', 'AZ', 'BS', 'BH', 'BD', 'BB', 'BY', 'BE', 'BZ', 'BJ', 'BM', 
    'BT', 'BO', 'BQ', 'BA', 'BW', 'BV', 'BR', 'IO', 'BN', 'BG', 'BF', 'BI', 
    'CV', 'KH', 'CM', 'CA', 'KY', 'CF', 'TD', 'CL', 'CN', 'CX', 'CC', 'CO', 
    'KM', 'CD', 'CG', 'CK', 'CR', 'HR', 'CU', 'CW', 'CY', 'CZ', 'CI', 'DK', 
    'DJ', 'DM', 'DO', 'EC', 'EG', 'SV', 'GQ', 'ER', 'EE', 'SZ', 'ET', 'FK', 
    'FO', 'FJ', 'FI', 'FR', 'GF', 'PF', 'TF', 'GA', 'GM', 'GE', 'DE', 'GH', 
    'GI', 'GR', 'GL', 'GD', 'GP', 'GU', 'GT', 'GG', 'GN', 'GW', 'GY', 'HT', 
    'HM', 'VA', 'HN', 'HK', 'HU', 'IS', 'IN', 'ID', 'IR', 'IQ', 'IE', 'IM', 
    'IL', 'IT', 'JM', 'JP', 'JE', 'JO', 'KZ', 'KE', 'KI', 'KP', 'KR', 'KW', 
    'KG', 'LA', 'LV', 'LB', 'LS', 'LR', 'LY', 'LI', 'LT', 'LU', 'MO', 'MG', 
    'MW', 'MY', 'MV', 'ML', 'MT', 'MH', 'MQ', 'MR', 'MU', 'YT', 'MX', 'FM', 
    'MD', 'MC', 'MN', 'ME', 'MS', 'MA', 'MZ', 'MM', 'NA', 'NR', 'NP', 'NL', 
    'NC', 'NZ', 'NI', 'NE', 'NG', 'NU', 'NF', 'MP', 'NO', 'OM', 'PK', 'PW', 
    'PS', 'PA', 'PG', 'PY', 'PE', 'PH', 'PN', 'PL', 'PT', 'PR', 'QA', 'MK', 
    'RO', 'RU', 'RW', 'RE', 'BL', 'SH', 'KN', 'LC', 'MF', 'PM', 'VC', 'WS', 
    'SM', 'ST', 'SA', 'SN', 'RS', 'SC', 'SL', 'SG', 'SX', 'SK', 'SI', 'SB', 
    'SO', 'ZA', 'GS', 'SS', 'ES', 'LK', 'SD', 'SR', 'SJ', 'SE', 'CH', 'SY', 
    'TW', 'TJ', 'TZ', 'TH', 'TL', 'TG', 'TK', 'TO', 'TT', 'TN', 'TR', 'TM', 
    'TC', 'TV', 'UG', 'UA', 'AE', 'GB', 'US', 'UM', 'UY', 'UZ', 'VU', 'VE', 
    'VN', 'VG', 'VI', 'WF', 'EH', 'YE', 'ZM', 'ZW'
  ],

  // Supported currencies (ISO 4217)
  CURRENCIES: ['USD', 'EUR', 'GBP', 'JPY', 'AUD', 'CAD', 'CHF', 'CNY', 'SEK', 'NZD'],

  // Bank account types
  ACCOUNT_TYPES: ['checking', 'savings', 'business', 'loan', 'credit'],

  // Transfer purposes
  TRANSFER_PURPOSES: [
    'family support',
    'business payment',
    'education fees',
    'medical expenses',
    'travel',
    'investment',
    'charity',
    'gift',
    'other'
  ],

  // Regex patterns
  PATTERNS: {
    IBAN: /^[A-Z]{2}\d{2}[A-Z0-9]{4}\d{7}([A-Z0-9]?){0,16}$/,
    SWIFT_BIC: /^[A-Z]{6}[A-Z0-9]{2}([A-Z0-9]{3})?$/,
    ROUTING_NUMBER: /^\d{9}$/,
    SORT_CODE: /^\d{6}$/,
    PHONE: /^[+]?[(]?[0-9]{1,4}[)]?[-\s./0-9]*$/,
    ACCOUNT_NUMBER: /^[A-Z0-9]{4,34}$/
  },

  // Limits
  LIMITS: {
    BENEFICIARY_NAME: { MIN: 2, MAX: 100 },
    BANK_NAME: { MIN: 2, MAX: 100 },
    NOTES: { MAX: 500 },
    TAG: { MAX: 20 },
    ADDRESS: { MIN: 10, MAX: 200 }
  },

  // Default values
  DEFAULTS: {
    BENEFICIARY_TYPE: 'local',
    TRANSFER_PURPOSE: 'other',
    CURRENCY: 'USD'
  }
};