const bcrypt = require("bcryptjs");

const hashPassword = async (password = "", salt = 10) => {
  try {
    if (!password.trim()) throw new Error("password is required for hashing");
    let hash = await bcrypt.hash(password, salt);
    return hash;
  } catch (error) {
    return error;
  }
};

//

const compareHash = async (string = "", hash = "") => {
  try {
    if (!string.trim() || !hash.trim())
      throw new Error("args is required for comparing");
    let isPwdMatch = await bcrypt.compare(string, hash);
    if (!isPwdMatch) return false;
    return isPwdMatch;
  } catch (error) {
    return false;
  }
};

const BCRYPT = {
  hashPassword,
  compareHash,
};

module.exports = {
  BCRYPT,
};
