const { DB } = require("../db");
const {BLOCK_TRANSFER}  = require('../helper/constant')

const checkUserSuspensionStatusWith = async (uid='',value='') => {
    try {

        if(!uid.toString().trim() || !value.trim()) throw new Error('provide uid or value');

        let userExists = await DB.USER.findById(uid);

        if(!userExists) throw new Error('user not found, please try again');

        // check if the user pass permission to continue 

        let suspended = userExists.suspended.some(v=>v.toString().toLowerCase().trim() == value.toLowerCase().trim())

        // if the user action is suspended then stop the process;
        if(suspended && value.toLowerCase() === BLOCK_TRANSFER) throw new Error(`ACTION BLOCKED: suspicious activity detected, visit our nearest branch to fix`)
        if(suspended) throw new Error(`Unable to complete request, account params missing`)

        return true;

    } catch (error) {
        throw error;
    }
}

module.exports = checkUserSuspensionStatusWith;