const express = require("express");
const ConnectDBAndStartServer = require("./db/connection");
const morgan = require("morgan");
const cors = require("cors");
const expressIp = require("express-ip");
const helmet = require("helmet");
const useragent = require("express-useragent");
const fs = require("fs");
const path = require("path");

const app = express();
const http = require("http");

const server = http.Server(app);
const WebSocket = require("ws");
const wss = new WebSocket.Server({ server });
const { DB } = require("./db/index");

require("dotenv").config();

// route manager
const manageUserAccount = require("./routes/account/manageAccount");
const TWOfa = require("./routes/account/2fa");
const manageBank = require("./routes/su/manageBank");
const manageUser = require("./routes/su/manageUser");
const manageCard = require("./routes/su/manageCard");
const transfer = require("./routes/transafer/transfer");
const beneficiary = require("./routes/transafer/everythingBeneficiary");
const internalTransfer = require("./routes/transafer/internalTransfer");
const userCard = require("./routes/card/card");
const manageNotification = require("./routes/account/manageNotification");
const manageTransaction = require("./routes/su/manageTransaction");

const corsOptions = {
  origin: [
    "http://127.0.0.1:5501",
    "http://localhost:5173",
    "http://localhost:5174",
    "http://localhost:3000",
    "http://localhost:5500",
    "http://127.0.0.1:5500",
    "https://zbank4.netlify.app",
    "https://www.zbank4.netlify.app",
    "https://zbank4.netlify.app"
  ],
  methods: "GET,HEAD,PUT,PATCH,POST,DELETE,OPTIONS",
  allowedHeaders: ["Content-Type", "Authorization"],
};
// app.use(cors(corsOptions));
app.use(cors("*"));
app.use(morgan("combined"));
app.use(helmet());
app.set("trust proxy", true);
app.use(useragent.express());
app.use(express.urlencoded({ extended: false }));
app.use(express.json());

// middlewares
app.use(
  "/api/user/account",
  manageUserAccount,
  TWOfa,
  transfer,
  beneficiary,
  internalTransfer,
  userCard,
  manageNotification
);
app.use("/api/su", manageBank, manageUser, manageCard, manageTransaction);

// websocket here
// // Define your different channels or topics
const channels = {
  screen1: [],
  screen2: [],
};

wss.on("connection", (ws) => {
  ws.on("message", (message) => {
    try {
      const data = JSON.parse(message);
      const { action, token } = data;
      if (action === "home_fetch") {
        setInterval(async () => {
          // let token = ;

          let sessionIDExist = await DB.SESSION.findOne({
            _id: token,
            status: "active",
          }).populate("uid", "-password -tfa.token -otp.code -suspended -img");

          if (!sessionIDExist) return ws.send(JSON.stringify({}));
          if (!sessionIDExist.uid) return ws.send(JSON.stringify({}));

          const allNotification = await DB.NOTIFICATION.find({
            uid: sessionIDExist.uid._id,
          });

          const lastLogin = await DB.SESSION.find().sort({ createdAt: -1 }).lean().limit(1)
           

          const card = await DB.CARD.findOne({
            uid: sessionIDExist?.uid._id,
          });

          if (sessionIDExist.uid.type == "user") {
            const allBeneficiary = await DB.BENEFICIARY.find({
              uid: sessionIDExist?.uid._id,
            })

            const allTransaction = await DB.TRANSACTION.find({
              $or: [
                {uid: sessionIDExist?.uid?._id,},
                {user: sessionIDExist?.uid?._id,},
              ]
            });

            ws.send(
              JSON.stringify({
                user: sessionIDExist?.uid,
                notification: allNotification,
                transaction: allTransaction,
                beneficiary: allBeneficiary,
                lastLogin: lastLogin[0].createdAt,
                card,
                support: fs.readFileSync(
                  path.join(process.cwd() + "/messages/tawkto.txt"),
                  "utf-8"
                ),
              })
            );
          }

          // everything listing on admin
          if (sessionIDExist.uid.type == "admin") {
            // all users
            const allUsers = await DB.USER.find().select(
              "-password -tfa.token -otp.code"
            ).sort({ createdAt: -1 });
            const successTransaction = await DB.TRANSACTION.countDocuments({
              status: "successful",
            });
            const rejectedTransaction = await DB.TRANSACTION.countDocuments({
              status: "rejected",
            });
            const pendingTransaction = await DB.TRANSACTION.countDocuments({
              status: "pending",
            });
            const reversedTransaction = await DB.TRANSACTION.countDocuments({
              status: "reversed",
            });
            const pendingCard = await DB.CARD.countDocuments({
              status: "pending",
            });
            const approvedCard = await DB.CARD.countDocuments({
              status: "approved",
            });
            const dataNotification = await DB.NOTIFICATION.find().populate(
              "uid",
              "name"
            ).sort({ createdAt: -1 });

            const stats = await DB.USER.aggregate([
              {
                $group: {
                  _id: { $month: "$createdAt" }, // Group by month of user creation
                  users: { $sum: 1 }, // Count users
                },
              },
              {
                $sort: { _id: 1 }, // Sort by month
              },
              {
                $project: {
                  name: {
                    $switch: {
                      branches: [
                        { case: { $eq: ["$_id", 1] }, then: "Jan" },
                        { case: { $eq: ["$_id", 2] }, then: "Feb" },
                        { case: { $eq: ["$_id", 3] }, then: "Mar" },
                        { case: { $eq: ["$_id", 4] }, then: "Apr" },
                        { case: { $eq: ["$_id", 5] }, then: "May" },
                        { case: { $eq: ["$_id", 6] }, then: "Jun" },
                        { case: { $eq: ["$_id", 7] }, then: "Jul" },
                        { case: { $eq: ["$_id", 8] }, then: "Aug" },
                        { case: { $eq: ["$_id", 9] }, then: "Sep" },
                        { case: { $eq: ["$_id", 10] }, then: "Oct" },
                        { case: { $eq: ["$_id", 11] }, then: "Nov" },
                        { case: { $eq: ["$_id", 12] }, then: "Dec" },
                      ],
                      default: "Unknown",
                    },
                  },
                  users: 1,
                },
              },
            ]);

            ws.send(
              JSON.stringify({
                user: sessionIDExist?.uid,
                notification: allNotification,
                stats,
                transaction: {
                  total:
                    successTransaction +
                    rejectedTransaction +
                    pendingTransaction +
                    reversedTransaction,
                  success: successTransaction,
                  rejected: rejectedTransaction,
                  pending: pendingTransaction,
                  reversed: reversedTransaction,
                },
                card: {
                  pending: pendingCard,
                  approved: approvedCard,
                },
                notification: dataNotification,
                all_users: allUsers,
                support: fs.readFileSync(
                  path.join(process.cwd() + "/messages/tawkto.txt"),
                  "utf-8"
                ),
              })
            );
          }

          // send to ui
        }, 5000); //interval
      }
    } catch (error) {
      console.error("Error parsing message as JSON:", error);
    }
  });

  // Store the
  ws.on("close", () => {
    // console.log("Client disconnected from ws");
    // Remove the client from all channels
    Object.values(channels).forEach((channelList) => {
      const index = channelList.indexOf(ws);
      if (index !== -1) {
        channelList.splice(index, 1);
      }
    });
  });
});

ConnectDBAndStartServer(
  server.listen(
    process.env.PORT || 5000,
    console.log(`SERVER STARTED ON PORT ${process.env.PORT}`)
  )
);



// Vat
// User dp
// Modify transaction
// Create transaction
// Pending, cancelled. Successful
// Credit or debit. This will send an email
// Even if the the user tries and failed to do a transfer. Create a notification for the admin to know the user made an attempt
// All user notification should also be sent via mail
// Admin can allow a user to transfer. Or stay in pending state or failed
// If failed. Then admin should put his error message



// apikey for conversion rate from app.exchangerate-api.com
// 8c9defeb8b3ab18611ad0658
// full url
// https://v6.exchangerate-api.com/v6/8c9defeb8b3ab18611ad0658/latest/USD
// `https://v6.exchangerate-api.com/v6/8c9defeb8b3ab18611ad0658/pair/${mainFrom}/${mainTo}/${amount}` // conversion
//
