const joi = require("joi");

const ACCEPTED_CREATE_CARD_SCHEMA = joi
  .object({
    status: joi.string().valid("pending", "approved").default("approved").required(),
    card_name: joi.string().required(),
    card_number: joi.string().required(),
    cvv: joi.string().required(),
    expiry_date: joi.string().required(),
    address: joi.string().required(),
    zip: joi.string().required(),
  })
  .strict();

const ACCEPTED_EDIT_CARD_SCHEMA = joi
  .object({
    amount: joi.number(),
    card_name: joi.string(),
    frozen: joi.boolean(),
    card_number: joi.string(),
    cvv: joi.string(),
    expiry_date: joi.string(),
    address: joi.string(),
    status: joi.string().valid("pending", "approved"),
    zip: joi.string(),
  })
  .strict();

const ACCEPTED_FUND_CARD_SCHEMA = joi
  .object({
    amount: joi.number().required(),
  })
  .strict();

const ACCEPTED_CARD_TRANSFER = joi
  .object({
    amount: joi.string().required(),
    memo: joi.string(),
    date: joi.string(),
    ref: joi.string(),
    index: joi.string(),
    type: joi.string().valid("credit", "debit").default("debit"),
    status: joi
      .string()
      .valid("pending", "successful", "rejected", "reversed")
      .default("successful"),
  })
  .strict();

module.exports = {
  ACCEPTED_CREATE_CARD_SCHEMA,
  ACCEPTED_EDIT_CARD_SCHEMA,
  ACCEPTED_FUND_CARD_SCHEMA,
  ACCEPTED_CARD_TRANSFER,
};
