const Joi = require('joi');

const transferSchema = Joi.object({
  // Either existing beneficiary or new beneficiary details
  beneficiaryId: Joi.string().hex().length(24),
  currency: Joi.string().valid('usd', 'euro','gbp').default('usd'),
  newBeneficiary: Joi.object({
    name: Joi.string().required(),
    accountNumber: Joi.string().required(),
    bankName: Joi.string(),
    type: Joi.string().valid('local', 'wire').default('local'),
    // Local transfer fields
    routingNumber: Joi.when('type', {
      is: 'local',
      then: Joi.string().required()
    }),
    // International transfer fields
    swiftCode: Joi.when('type', {
      is: 'wire',
      then: Joi.string().required()
    }),
    country: Joi.when('type', {
      is: 'wire',
      then: Joi.string().required()
    })
  }),

  
  saveBeneficiary: Joi.boolean().default(false),
  amount: Joi.number().positive().precision(2).required(),
  memo: Joi.string().max(200).optional()
}).xor('beneficiaryId', 'newBeneficiary'); // Require one or the other

module.exports = {
  transferSchema
};